document.addEventListener('DOMContentLoaded', function() {
    // Smooth scroll for anchors (if any)
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();

            document.querySelector(this.getAttribute('href')).scrollIntoView({
                behavior: 'smooth'
            });
        });
    });

    // Toggle detail views on index page
    document.querySelectorAll('.toggle-detail').forEach(button => {
        button.addEventListener('click', function() {
            const targetId = this.dataset.target;
            const detailElement = document.getElementById(targetId);
            if (detailElement) {
                if (detailElement.style.display === 'none' || detailElement.style.display === '') {
                    detailElement.style.display = 'block';
                    this.textContent = 'Sembunyikan Detail';
                } else {
                    detailElement.style.display = 'none';
                    this.textContent = 'Tampilkan Detail';
                }
            }
        });
    });

    // Konfirmasi penghapusan
    document.querySelectorAll('.btn-danger.confirm-delete').forEach(button => {
        button.addEventListener('click', function(e) {
            if (!confirm('Apakah Anda yakin ingin menghapus data ini?')) {
                e.preventDefault();
            }
        });
    });
});