<?php
require_once 'config.php';
require_once 'functions.php';

check_login(); // Pastikan user sudah login

$user_id = $_SESSION['user_id'];
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $current_password = trim($_POST['current_password']);
    $new_password = trim($_POST['new_password']);
    $confirm_new_password = trim($_POST['confirm_new_password']);

    // Ambil hashed password dari database
    $stmt = $conn->prepare("SELECT password FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();

    if ($user) {
        if (!password_verify($current_password, $user['password'])) {
            $error_message = "Password lama salah.";
        } elseif (empty($new_password) || empty($confirm_new_password)) {
            $error_message = "Password baru dan konfirmasi password harus diisi.";
        } elseif ($new_password !== $confirm_new_password) {
            $error_message = "Password baru dan konfirmasi password tidak cocok.";
        } elseif (strlen($new_password) < 6) {
            $error_message = "Password baru minimal 6 karakter.";
        } else {
            // Hash password baru
            $hashed_new_password = password_hash($new_password, PASSWORD_DEFAULT);

            // Update password di database
            $stmt_update = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
            $stmt_update->bind_param("si", $hashed_new_password, $user_id);
            if ($stmt_update->execute()) {
                $success_message = "Password berhasil diubah. Anda akan diarahkan ke dashboard.";
                // Redirect setelah beberapa detik
                echo "<script>setTimeout(function(){ ";
                if ($_SESSION['role'] == 'administrator') {
                    echo "window.location.href='dashboard_admin.php';";
                } elseif ($_SESSION['role'] == 'kaprodi') {
                    echo "window.location.href='dashboard_kaprodi.php';";
                } elseif ($_SESSION['role'] == 'mahasiswa') {
                    echo "window.location.href='dashboard_mahasiswa.php';";
                }
                echo " }, 3000);</script>";

            } else {
                $error_message = "Gagal mengubah password: " . $stmt_update->error;
            }
            $stmt_update->close();
        }
    } else {
        $error_message = "User tidak ditemukan."; // Seharusnya tidak terjadi jika check_login() berfungsi
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ganti Password</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>Ganti Password</h1>
        </header>
        <nav>
            <ul>
                <?php if (isset($_SESSION['role'])): ?>
                    <?php if ($_SESSION['role'] == 'administrator'): ?>
                        <li><a href="dashboard_admin.php">Dashboard Admin</a></li>
                    <?php elseif ($_SESSION['role'] == 'kaprodi'): ?>
                        <li><a href="dashboard_kaprodi.php">Dashboard Kaprodi</a></li>
                    <?php elseif ($_SESSION['role'] == 'mahasiswa'): ?>
                        <li><a href="dashboard_mahasiswa.php">Dashboard Mahasiswa</a></li>
                    <?php endif; ?>
                    <li><a href="change_password.php">Ganti Password</a></li>
                    <li><a href="logout.php">Logout</a></li>
                <?php else: ?>
                    <li><a href="login.php">Login</a></li>
                <?php endif; ?>
            </ul>
        </nav>
        <main>
            <h2>Form Ganti Password</h2>
            <?php if (!empty($success_message)): ?>
                <div class="alert alert-success"><?php echo $success_message; ?></div>
            <?php endif; ?>
            <?php if (!empty($error_message)): ?>
                <div class="alert alert-danger"><?php echo $error_message; ?></div>
            <?php endif; ?>

            <form action="change_password.php" method="POST">
                <div class="form-group">
                    <label for="current_password">Password Lama:</label>
                    <input type="password" id="current_password" name="current_password" required>
                </div>
                <div class="form-group">
                    <label for="new_password">Password Baru:</label>
                    <input type="password" id="new_password" name="new_password" required>
                </div>
                <div class="form-group">
                    <label for="confirm_new_password">Konfirmasi Password Baru:</label>
                    <input type="password" id="confirm_new_password" name="confirm_new_password" required>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn">Ganti Password</button>
                    <a href="
                        <?php
                            if ($_SESSION['role'] == 'administrator') { echo 'dashboard_admin.php'; }
                            elseif ($_SESSION['role'] == 'kaprodi') { echo 'dashboard_kaprodi.php'; }
                            elseif ($_SESSION['role'] == 'mahasiswa') { echo 'dashboard_mahasiswa.php'; }
                        ?>
                    " class="btn btn-warning">Batal</a>
                </div>
            </form>
        </main>
    </div>
    <script src="assets/js/script.js"></script>
</body>
</html>