<?php
require_once 'config.php';
require_once 'functions.php';

check_login();
check_role(['administrator']);

// Logika untuk menampilkan informasi dashboard admin
$total_mahasiswa = 0;
$total_kaprodi = 0;
$total_kegiatan = 0;
$total_prodi = 0;

$stmt_mhs = $conn->prepare("SELECT COUNT(*) AS total FROM users WHERE role = 'mahasiswa'");
$stmt_mhs->execute();
$result_mhs = $stmt_mhs->get_result();
$total_mahasiswa = $result_mhs->fetch_assoc()['total'];
$stmt_mhs->close();

$stmt_kaprodi = $conn->prepare("SELECT COUNT(*) AS total FROM users WHERE role = 'kaprodi'");
$stmt_kaprodi->execute();
$result_kaprodi = $stmt_kaprodi->get_result();
$total_kaprodi = $result_kaprodi->fetch_assoc()['total'];
$stmt_kaprodi->close();

$stmt_kegiatan = $conn->prepare("SELECT COUNT(*) AS total FROM kegiatan");
$stmt_kegiatan->execute();
$result_kegiatan = $stmt_kegiatan->get_result();
$total_kegiatan = $result_kegiatan->fetch_assoc()['total'];
$stmt_kegiatan->close();

$stmt_prodi = $conn->prepare("SELECT COUNT(*) AS total FROM prodi");
$stmt_prodi->execute();
$result_prodi = $stmt_prodi->get_result();
$total_prodi = $result_prodi->fetch_assoc()['total'];
$stmt_prodi->close();

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Administrator</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>Dashboard Administrator</h1>
        </header>
        <nav>
            <ul>
                <li><a href="dashboard_admin.php">Home</a></li>
                <li><a href="kaprodi.php">Manajemen Kaprodi</a></li>
                <li><a href="change_password.php">Ganti Password</a></li>
                <li><a href="logout.php">Logout</a></li>
            </ul>
        </nav>
        <main>
            <h2>Selamat Datang, <?php echo $_SESSION['nama_lengkap']; ?>!</h2>
            <div style="display: flex; flex-wrap: wrap; gap: 20px;">
                <div class="dashboard-card" style="flex: 1 1 200px;">
                    <h3>Total Mahasiswa</h3>
                    <p><?php echo $total_mahasiswa; ?></p>
                </div>
                <div class="dashboard-card" style="flex: 1 1 200px;">
                    <h3>Total Kaprodi</h3>
                    <p><?php echo $total_kaprodi; ?></p>
                </div>
                <div class="dashboard-card" style="flex: 1 1 200px;">
                    <h3>Total Kegiatan</h3>
                    <p><?php echo $total_kegiatan; ?></p>
                </div>
                <div class="dashboard-card" style="flex: 1 1 200px;">
                    <h3>Total Program Studi</h3>
                    <p><?php echo $total_prodi; ?></p>
                </div>
            </div>

            <h3>Aksi Cepat:</h3>
            <ul>
                <li><a href="kaprodi.php" class="btn">Kelola Kaprodi</a></li>
            </ul>
        </main>
    </div>
    <script src="assets/js/script.js"></script>
</body>
</html>