<?php
require_once 'config.php';
require_once 'functions.php';

check_login();
check_role(['kaprodi']);

$kaprodi_prodi_id = $_SESSION['prodi_id'];
$nama_prodi_kaprodi = get_prodi_name($kaprodi_prodi_id, $conn);

// Logika untuk menampilkan informasi dashboard kaprodi
$total_mahasiswa_prodi = 0;
$total_kegiatan_prodi = 0;
$total_kredit_terdistribusi = 0;

$stmt_mhs = $conn->prepare("SELECT COUNT(*) AS total FROM users WHERE role = 'mahasiswa' AND prodi_id = ?");
$stmt_mhs->bind_param("i", $kaprodi_prodi_id);
$stmt_mhs->execute();
$result_mhs = $stmt_mhs->get_result();
$total_mahasiswa_prodi = $result_mhs->fetch_assoc()['total'];
$stmt_mhs->close();

$stmt_kegiatan = $conn->prepare("SELECT COUNT(*) AS total FROM kegiatan WHERE prodi_id = ?");
$stmt_kegiatan->bind_param("i", $kaprodi_prodi_id);
$stmt_kegiatan->execute();
$result_kegiatan = $stmt_kegiatan->get_result();
$total_kegiatan_prodi = $result_kegiatan->fetch_assoc()['total'];
$stmt_kegiatan->close();

$stmt_kredit = $conn->prepare("
    SELECT SUM(k.kredit_poin) AS total_kredit
    FROM kehadiran_kegiatan kk
    JOIN kegiatan k ON kk.kegiatan_id = k.id
    WHERE k.prodi_id = ?
");
$stmt_kredit->bind_param("i", $kaprodi_prodi_id);
$stmt_kredit->execute();
$result_kredit = $stmt_kredit->get_result();
$total_kredit_terdistribusi = $result_kredit->fetch_assoc()['total_kredit'] ?? 0;
$stmt_kredit->close();


$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Kaprodi</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>Dashboard Kaprodi</h1>
        </header>
        <nav>
            <ul>
                <li><a href="dashboard_kaprodi.php">Home</a></li>
                <li><a href="mahasiswa.php">Manajemen Mahasiswa</a></li>
                <li><a href="kegiatan.php">Manajemen Kegiatan</a></li>
                <li><a href="change_password.php">Ganti Password</a></li>
                <li><a href="logout.php">Logout</a></li>
            </ul>
        </nav>
        <main>
            <h2>Selamat Datang, <?php echo $_SESSION['nama_lengkap']; ?>!</h2>
            <p>Anda adalah Kaprodi untuk Program Studi: **<?php echo htmlspecialchars($nama_prodi_kaprodi); ?>**</p>

            <div style="display: flex; flex-wrap: wrap; gap: 20px;">
                <div class="dashboard-card" style="