<?php
require_once 'config.php';
require_once 'functions.php';

check_login();
check_role(['mahasiswa']);

$mahasiswa_id = $_SESSION['user_id'];
$prodi_id_mahasiswa = $_SESSION['prodi_id'];
$nama_prodi_mahasiswa = get_prodi_name($prodi_id_mahasiswa, $conn);

$total_kredit_poin = 0;
$jumlah_kegiatan_diikuti = 0;
$daftar_kegiatan = [];

// Hitung total kredit poin mahasiswa
$stmt_kredit = $conn->prepare("
    SELECT SUM(k.kredit_poin) AS total_poin
    FROM kehadiran_kegiatan kk
    JOIN kegiatan k ON kk.kegiatan_id = k.id
    WHERE kk.mahasiswa_id = ?
");
$stmt_kredit->bind_param("i", $mahasiswa_id);
$stmt_kredit->execute();
$result_kredit = $stmt_kredit->get_result();
$total_kredit_poin = $result_kredit->fetch_assoc()['total_poin'] ?? 0;
$stmt_kredit->close();

// Hitung jumlah kegiatan yang diikuti
$stmt_jumlah_kegiatan = $conn->prepare("
    SELECT COUNT(DISTINCT kegiatan_id) AS jumlah_kegiatan
    FROM kehadiran_kegiatan
    WHERE mahasiswa_id = ?
");
$stmt_jumlah_kegiatan->bind_param("i", $mahasiswa_id);
$stmt_jumlah_kegiatan->execute();
$result_jumlah_kegiatan = $stmt_jumlah_kegiatan->get_result();
$jumlah_kegiatan_diikuti = $result_jumlah_kegiatan->fetch_assoc()['jumlah_kegiatan'] ?? 0;
$stmt_jumlah_kegiatan->close();

// Ambil daftar kegiatan yang diikuti mahasiswa
$stmt_kegiatan_diikuti = $conn->prepare("
    SELECT k.nama_kegiatan, k.kredit_poin, k.tanggal_pelaksanaan
    FROM kehadiran_kegiatan kk
    JOIN kegiatan k ON kk.kegiatan_id = k.id
    WHERE kk.mahasiswa_id = ?
    ORDER BY k.tanggal_pelaksanaan DESC
");
$stmt_kegiatan_diikuti->bind_param("i", $mahasiswa_id);
$stmt_kegiatan_diikuti->execute();
$result_kegiatan_diikuti = $stmt_kegiatan_diikuti->get_result();
while ($row = $result_kegiatan_diikuti->fetch_assoc()) {
    $daftar_kegiatan[] = $row;
}
$stmt_kegiatan_diikuti->close();


$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Mahasiswa</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>Dashboard Mahasiswa</h1>
        </header>
        <nav>
            <ul>
                <li><a href="dashboard_mahasiswa.php">Home</a></li>
                <li><a href="change_password.php">Ganti Password</a></li>
                <li><a href="logout.php">Logout</a></li>
            </ul>
        </nav>
        <main>
            <h2>Selamat Datang, <?php echo $_SESSION['nama_lengkap']; ?>!</h2>
            <p>NIM: **<?php echo htmlspecialchars($_SESSION['username']); ?>**</p>
            <p>Program Studi: **<?php echo htmlspecialchars($nama_prodi_mahasiswa); ?>**</p>

            <div style="display: flex; flex-wrap: wrap; gap: 20px;">
                <div class="dashboard-card" style="flex: 1 1 250px;">
                    <h3>Total Kredit Poin Anda</h3>
                    <p><?php echo $total_kredit_poin; ?></p>
                </div>
                <div class="dashboard-card" style="flex: 1 1 250px;">
                    <h3>Jumlah Kegiatan Diikuti</h3>
                    <p><?php echo $jumlah_kegiatan_diikuti; ?></p>
                </div>
            </div>

            <h3>Daftar Kegiatan yang Anda Ikuti:</h3>
            <?php if (!empty($daftar_kegiatan)): ?>
                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Nama Kegiatan</th>
                                <th>Kredit Poin</th>
                                <th>Tanggal Pelaksanaan</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1; foreach ($daftar_kegiatan as $kegiatan): ?>
                                <tr>
                                    <td><?php echo $no++; ?></td>
                                    <td><?php echo htmlspecialchars($kegiatan['nama_kegiatan']); ?></td>
                                    <td><?php echo htmlspecialchars($kegiatan['kredit_poin']); ?></td>
                                    <td><?php echo date('d-m-Y', strtotime($kegiatan['tanggal_pelaksanaan'])); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p>Anda belum mengikuti kegiatan apapun.</p>
            <?php endif; ?>
        </main>
    </div>
    <script src="assets/js/script.js"></script>
</body>
</html>