<?php
session_start();

function redirect($url) {
    echo "<script>window.location.href='" . $url . "';</script>";
    exit();
}

function check_login() {
    if (!isset($_SESSION['user_id'])) {
        redirect('login.php');
    }
}

function check_role($allowed_roles) {
    if (!in_array($_SESSION['role'], $allowed_roles)) {
        echo "<script>alert('Anda tidak memiliki akses ke halaman ini.');</script>";
        redirect('index.php'); // Atau halaman yang sesuai
    }
}

function get_prodi_name($prodi_id, $conn) {
    $stmt = $conn->prepare("SELECT nama_prodi FROM prodi WHERE id = ?");
    $stmt->bind_param("i", $prodi_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $prodi = $result->fetch_assoc();
    $stmt->close();
    return $prodi ? $prodi['nama_prodi'] : 'N/A';
}
?>