<?php
require_once 'config.php';
require_once 'functions.php';

// Ambil semua prodi untuk filter
$prodi_list = [];
$stmt_prodi = $conn->prepare("SELECT id, nama_prodi FROM prodi ORDER BY nama_prodi ASC");
$stmt_prodi->execute();
$result_prodi = $stmt_prodi->get_result();
while ($row = $result_prodi->fetch_assoc()) {
    $prodi_list[] = $row;
}
$stmt_prodi->close();

$selected_prodi_id = isset($_GET['prodi_filter']) ? (int)$_GET['prodi_filter'] : 0;
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Kredit Poin Mahasiswa</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h3>KREDIT POIN MAHASISWA PROGRAM STUDI SARJANA TEOLOGI<br>
SEKOLAH TINGGI TEOLOGI BETHEL INDONESIA</h3>
        </header>
        <nav>
            <ul>
                <li><a href="index.php">Home</a></li>
                <?php if (isset($_SESSION['user_id'])): ?>
                    <?php if ($_SESSION['role'] == 'administrator'): ?>
                        <li><a href="dashboard_admin.php">Dashboard Admin</a></li>
                    <?php elseif ($_SESSION['role'] == 'kaprodi'): ?>
                        <li><a href="dashboard_kaprodi.php">Dashboard Kaprodi</a></li>
                    <?php elseif ($_SESSION['role'] == 'mahasiswa'): ?>
                        <li><a href="dashboard_mahasiswa.php">Dashboard Mahasiswa</a></li>
                    <?php endif; ?>
                    <li><a href="logout.php">Logout (<?php echo $_SESSION['username']; ?>)</a></li>
                <?php else: ?>
                    <li><a href="login.php">Login</a></li>
                    <li><a href="register.php">Register</a></li>
                <?php endif; ?>
            </ul>
        </nav>
        <main>
            <form action="index.php" method="GET" style="margin-bottom: 20px;">
                <div class="form-group" style="display: flex; gap: 10px; align-items: flex-end;">
                    <div style="flex-grow: 1;">
                        <label for="prodi_filter">Filter Berdasarkan Program Studi:</label>
                        <select id="prodi_filter" name="prodi_filter" onChange="this.form.submit()">
                
                            <?php foreach ($prodi_list as $prodi): ?>
                                <option value="<?php echo $prodi['id']; ?>" <?php echo ($selected_prodi_id == $prodi['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($prodi['nama_prodi']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php if ($selected_prodi_id != 0): ?>
                        <a href="index.php" class="btn btn-warning">Reset Filter</a>
                    <?php endif; ?>
                </div>
            </form>

            <h2 style="margin-top: 30px;">Daftar Mahasiswa Berdasarkan Angkatan/ Tahun Masuk</h2>
            <?php
            $sql_mahasiswa = "
                SELECT 
                    u.id, u.nama_lengkap, u.nim, u.tahun_masuk, p.nama_prodi,
                    SUM(COALESCE(k.kredit_poin, 0)) AS total_kredit_poin
                FROM users u
                JOIN prodi p ON u.prodi_id = p.id
                LEFT JOIN kehadiran_kegiatan kk ON u.id = kk.mahasiswa_id
                LEFT JOIN kegiatan k ON kk.kegiatan_id = k.id
                WHERE u.role = 'mahasiswa'
            ";

            $params_mhs = [];
            $types_mhs = "";

            if ($selected_prodi_id != 0) {
                $sql_mahasiswa .= " AND u.prodi_id = ?";
                $params_mhs[] = $selected_prodi_id;
                $types_mhs .= "i";
            }

            $sql_mahasiswa .= "
                GROUP BY u.id, u.nama_lengkap, u.nim, u.tahun_masuk, p.nama_prodi
                ORDER BY u.tahun_masuk DESC, u.nama_lengkap ASC
            ";

            $stmt_mahasiswa = $conn->prepare($sql_mahasiswa);
            if (!empty($params_mhs)) {
                $stmt_mahasiswa->bind_param($types_mhs, ...$params_mhs);
            }
            $stmt_mahasiswa->execute();
            $result_mahasiswa = $stmt_mahasiswa->get_result();

            $mahasiswa_by_tahun = [];
            while ($row = $result_mahasiswa->fetch_assoc()) {
                $mahasiswa_by_tahun[$row['tahun_masuk']][] = $row;
            }
            $stmt_mahasiswa->close();

            if (!empty($mahasiswa_by_tahun)):
                foreach ($mahasiswa_by_tahun as $tahun_masuk => $mahasiswa_list): ?>
                    <div class="mahasiswa-group">
                        <h3>Prodi <?php echo htmlspecialchars($mahasiswa_list[0]['nama_prodi']); ?> Angkatan <?php echo $tahun_masuk; ?></h3>
                        <ul>
                            <?php foreach ($mahasiswa_list as $mahasiswa): ?>
                                <li class="mahasiswa-item">
                                    <a href="#" class="toggle-detail" data-target="mhs-detail-<?php echo $mahasiswa['id']; ?>">
                                        <?php echo htmlspecialchars($mahasiswa['nama_lengkap']); ?> (NIM: <?php echo htmlspecialchars($mahasiswa['nim']); ?>) - Total Kredit: <?php echo $mahasiswa['total_kredit_poin']; ?>
                                    </a>
                                    <div id="mhs-detail-<?php echo $mahasiswa['id']; ?>" class="hidden-detail">
                                        <h4>Detail Kegiatan yang Diikuti:</h4>
                                        <?php
                                        $stmt_keg_mhs = $conn->prepare("
                                            SELECT k.nama_kegiatan, k.kredit_poin, k.tanggal_pelaksanaan
                                            FROM kehadiran_kegiatan kk
                                            JOIN kegiatan k ON kk.kegiatan_id = k.id
                                            WHERE kk.mahasiswa_id = ?
                                            ORDER BY k.tanggal_pelaksanaan DESC
                                        ");
                                        $stmt_keg_mhs->bind_param("i", $mahasiswa['id']);
                                        $stmt_keg_mhs->execute();
                                        $result_keg_mhs = $stmt_keg_mhs->get_result();
                                        if ($result_keg_mhs->num_rows > 0): ?>
                                            <ul>
                                                <?php while ($kegiatan_mhs = $result_keg_mhs->fetch_assoc()): ?>
                                                    <li><?php echo htmlspecialchars($kegiatan_mhs['nama_kegiatan']); ?> (<?php echo htmlspecialchars($kegiatan_mhs['kredit_poin']); ?> Poin) - <?php echo date('d-m-Y', strtotime($kegiatan_mhs['tanggal_pelaksanaan'])); ?></li>
                                                <?php endwhile; ?>
                                            </ul>
                                        <?php else: ?>
                                            <p>Belum ada kegiatan yang diikuti.</p>
                                        <?php endif;
                                        $stmt_keg_mhs->close();
                                        ?>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endforeach;
            else: ?>
                <p>Tidak ada data mahasiswa yang ditemukan.</p>
            <?php endif; ?>

            <h2 style="margin-top: 40px;">Daftar Semua Kegiatan</h2>
            <?php
            $sql_kegiatan = "
                SELECT 
                    k.id, k.nama_kegiatan, k.kredit_poin, k.tanggal_pelaksanaan, p.nama_prodi,
                    COUNT(kk.mahasiswa_id) AS jumlah_peserta
                FROM kegiatan k
                JOIN prodi p ON k.prodi_id = p.id
                LEFT JOIN kehadiran_kegiatan kk ON k.id = kk.kegiatan_id
            ";

            $params_keg = [];
            $types_keg = "";

            if ($selected_prodi_id != 0) {
                $sql_kegiatan .= " WHERE k.prodi_id = ?";
                $params_keg[] = $selected_prodi_id;
                $types_keg .= "i";
            }

            $sql_kegiatan .= "
                GROUP BY k.id, k.nama_kegiatan, k.kredit_poin, k.tanggal_pelaksanaan, p.nama_prodi
                ORDER BY k.tanggal_pelaksanaan DESC
            ";

            $stmt_kegiatan = $conn->prepare($sql_kegiatan);
            if (!empty($params_keg)) {
                $stmt_kegiatan->bind_param($types_keg, ...$params_keg);
            }
            $stmt_kegiatan->execute();
            $result_kegiatan = $stmt_kegiatan->get_result();

            if ($result_kegiatan->num_rows > 0): ?>
                <ul class="kegiatan-list">
                    <?php while ($kegiatan = $result_kegiatan->fetch_assoc()): ?>
                        <li>
                            <a href="#" class="toggle-detail" data-target="kegiatan-detail-<?php echo $kegiatan['id']; ?>">
                                <?php echo htmlspecialchars($kegiatan['nama_kegiatan']); ?> (<?php echo htmlspecialchars($kegiatan['kredit_poin']); ?> Poin) - Tanggal: <?php echo date('d-m-Y', strtotime($kegiatan['tanggal_pelaksanaan'])); ?> (Prodi: <?php echo htmlspecialchars($kegiatan['nama_prodi']); ?>) - Peserta: <?php echo $kegiatan['jumlah_peserta']; ?>
                            </a>
                            <div id="kegiatan-detail-<?php echo $kegiatan['id']; ?>" class="hidden-detail">
                                <h4>Peserta Kegiatan:</h4>
                                <?php
                                $stmt_peserta = $conn->prepare("
                                    SELECT u.nama_lengkap, u.nim
                                    FROM kehadiran_kegiatan kk
                                    JOIN users u ON kk.mahasiswa_id = u.id
                                    WHERE kk.kegiatan_id = ?
                                    ORDER BY u.nama_lengkap ASC
                                ");
                                $stmt_peserta->bind_param("i", $kegiatan['id']);
                                $stmt_peserta->execute();
                                $result_peserta = $stmt_peserta->get_result();
                                if ($result_peserta->num_rows > 0): ?>
                                    <ul>
                                        <?php while ($peserta = $result_peserta->fetch_assoc()): ?>
                                            <li><?php echo htmlspecialchars($peserta['nama_lengkap']); ?> (NIM: <?php echo htmlspecialchars($peserta['nim']); ?>)</li>
                                        <?php endwhile; ?>
                                    </ul>
                                <?php else: ?>
                                    <p>Belum ada mahasiswa yang mengikuti kegiatan ini.</p>
                                <?php endif;
                                $stmt_peserta->close();
                                ?>
                            </div>
                        </li>
                    <?php endwhile; ?>
                </ul>
            <?php else: ?>
                <p>Tidak ada kegiatan yang diselenggarakan.</p>
            <?php endif;
            $conn->close();
            ?>
        </main>
    </div>
    <script src="assets/js/script.js"></script>
</body>
</html>