<?php
require_once 'config.php';
require_once 'functions.php';

check_login();
check_role(['kaprodi']);

$kaprodi_id = $_SESSION['user_id'];
$kaprodi_prodi_id = $_SESSION['prodi_id'];

$success_message = '';
$error_message = '';

// --- Logika CRUD Kegiatan ---

// Tambah Kegiatan
if (isset($_POST['add_kegiatan'])) {
    $nama_kegiatan = trim($_POST['nama_kegiatan']);
    $kredit_poin = (int)$_POST['kredit_poin'];
    $tanggal_pelaksanaan = $_POST['tanggal_pelaksanaan'];

    if (empty($nama_kegiatan) || empty($kredit_poin) || empty($tanggal_pelaksanaan)) {
        $error_message = "Nama kegiatan, kredit poin, dan tanggal pelaksanaan harus diisi.";
    } elseif ($kredit_poin <= 0) {
        $error_message = "Kredit poin harus lebih dari 0.";
    } else {
        $stmt = $conn->prepare("INSERT INTO kegiatan (nama_kegiatan, kredit_poin, tanggal_pelaksanaan, prodi_id, created_by_kaprodi_id) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sisii", $nama_kegiatan, $kredit_poin, $tanggal_pelaksanaan, $kaprodi_prodi_id, $kaprodi_id);
        if ($stmt->execute()) {
            $success_message = "Kegiatan berhasil ditambahkan.";
            // Clear form
            $_POST = array();
        } else {
            $error_message = "Gagal menambahkan kegiatan: " . $stmt->error;
        }
        $stmt->close();
    }
}

// Edit Kegiatan
if (isset($_POST['edit_kegiatan'])) {
    $id_kegiatan = (int)$_POST['id_kegiatan'];
    $nama_kegiatan = trim($_POST['nama_kegiatan']);
    $kredit_poin = (int)$_POST['kredit_poin'];
    $tanggal_pelaksanaan = $_POST['tanggal_pelaksanaan'];

    if (empty($nama_kegiatan) || empty($kredit_poin) || empty($tanggal_pelaksanaan)) {
        $error_message = "Nama kegiatan, kredit poin, dan tanggal pelaksanaan harus diisi.";
    } elseif ($kredit_poin <= 0) {
        $error_message = "Kredit poin harus lebih dari 0.";
    } else {
        // Pastikan kaprodi yang mengedit adalah pemilik kegiatan dan dari prodi yang sama
        $stmt_check = $conn->prepare("SELECT id FROM kegiatan WHERE id = ? AND prodi_id = ? AND created_by_kaprodi_id = ?");
        $stmt_check->bind_param("iii", $id_kegiatan, $kaprodi_prodi_id, $kaprodi_id);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();
        if ($result_check->num_rows == 0) {
            $error_message = "Anda tidak memiliki izin untuk mengedit kegiatan ini.";
        } else {
            $stmt = $conn->prepare("UPDATE kegiatan SET nama_kegiatan = ?, kredit_poin = ?, tanggal_pelaksanaan = ? WHERE id = ?");
            $stmt->bind_param("sisi", $nama_kegiatan, $kredit_poin, $tanggal_pelaksanaan, $id_kegiatan);
            if ($stmt->execute()) {
                $success_message = "Kegiatan berhasil diperbarui.";
            } else {
                $error_message = "Gagal memperbarui kegiatan: " . $stmt->error;
            }
            $stmt->close();
        }
        $stmt_check->close();
    }
}

// Hapus Kegiatan
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id_kegiatan = (int)$_GET['id'];

    // Pastikan kaprodi yang menghapus adalah pemilik kegiatan dan dari prodi yang sama
    $stmt_check = $conn->prepare("SELECT id FROM kegiatan WHERE id = ? AND prodi_id = ? AND created_by_kaprodi_id = ?");
    $stmt_check->bind_param("iii", $id_kegiatan, $kaprodi_prodi_id, $kaprodi_id);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();
    if ($result_check->num_rows == 0) {
        $error_message = "Anda tidak memiliki izin untuk menghapus kegiatan ini.";
    } else {
        // Hapus kehadiran terlebih dahulu karena ada foreign key constraint
        $stmt_delete_kehadiran = $conn->prepare("DELETE FROM kehadiran_kegiatan WHERE kegiatan_id = ?");
        $stmt_delete_kehadiran->bind_param("i", $id_kegiatan);
        $stmt_delete_kehadiran->execute();
        $stmt_delete_kehadiran->close();

        $stmt = $conn->prepare("DELETE FROM kegiatan WHERE id = ?");
        $stmt->bind_param("i", $id_kegiatan);
        if ($stmt->execute()) {
            $success_message = "Kegiatan berhasil dihapus.";
        } else {
            $error_message = "Gagal menghapus kegiatan: " . $stmt->error;
        }
        $stmt->close();
    }
    redirect('kegiatan.php'); // Redirect untuk menghindari resubmission form
}

// --- Logika Pencatatan Kehadiran Mahasiswa ---
if (isset($_POST['record_kehadiran'])) {
    $kegiatan_id = (int)$_POST['kegiatan_id'];
    $mahasiswa_hadir = $_POST['mahasiswa_hadir'] ?? []; // Array of mahasiswa IDs

    // Pastikan kegiatan ini milik kaprodi yang sedang login
    $stmt_check_keg = $conn->prepare("SELECT id FROM kegiatan WHERE id = ? AND prodi_id = ?");
    $stmt_check_keg->bind_param("ii", $kegiatan_id, $kaprodi_prodi_id);
    $stmt_check_keg->execute();
    $result_check_keg = $stmt_check_keg->get_result();
    if ($result_check_keg->num_rows == 0) {
        $error_message = "Kegiatan tidak ditemukan atau Anda tidak memiliki akses ke kegiatan ini.";
    } else {
        // Hapus semua kehadiran lama untuk kegiatan ini
        $stmt_delete_old = $conn->prepare("DELETE FROM kehadiran_kegiatan WHERE kegiatan_id = ?");
        $stmt_delete_old->bind_param("i", $kegiatan_id);
        $stmt_delete_old->execute();
        $stmt_delete_old->close();

        // Tambahkan kehadiran baru
        if (!empty($mahasiswa_hadir)) {
            $stmt_insert = $conn->prepare("INSERT INTO kehadiran_kegiatan (kegiatan_id, mahasiswa_id) VALUES (?, ?)");
            foreach ($mahasiswa_hadir as $mhs_id) {
                $stmt_insert->bind_param("ii", $kegiatan_id, $mhs_id);
                $stmt_insert->execute();
            }
            $stmt_insert->close();
        }
        $success_message = "Kehadiran mahasiswa berhasil diperbarui.";
    }
    $stmt_check_keg->close();
    // Redirect ke halaman yang sama dengan parameter kegiatan_id agar form tetap terbuka
    redirect('kegiatan.php?action=record_attendance&id=' . $kegiatan_id);
}

// --- Ambil Data Kegiatan untuk Kaprodi yang Login ---
$kegiatan_list = [];
$stmt = $conn->prepare("SELECT id, nama_kegiatan, kredit_poin, tanggal_pelaksanaan FROM kegiatan WHERE prodi_id = ? ORDER BY tanggal_pelaksanaan DESC");
$stmt->bind_param("i", $kaprodi_prodi_id);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $kegiatan_list[] = $row;
}
$stmt->close();

// Ambil data kegiatan untuk form edit jika ada parameter 'action=edit'
$kegiatan_to_edit = null;
if (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['id'])) {
    $id_kegiatan = (int)$_GET['id'];
    $stmt = $conn->prepare("SELECT id, nama_kegiatan, kredit_poin, tanggal_pelaksanaan FROM kegiatan WHERE id = ? AND prodi_id = ? AND created_by_kaprodi_id = ?");
    $stmt->bind_param("iii", $id_kegiatan, $kaprodi_prodi_id, $kaprodi_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows == 1) {
        $kegiatan_to_edit = $result->fetch_assoc();
    } else {
        $error_message = "Kegiatan tidak ditemukan atau Anda tidak memiliki izin untuk mengedit.";
        redirect('kegiatan.php'); // Redirect jika tidak valid
    }
    $stmt->close();
}

// Ambil data mahasiswa untuk form pencatatan kehadiran jika ada parameter 'action=record_attendance'
$kegiatan_to_record_attendance = null;
$mahasiswa_prodi = []; // Semua mahasiswa di prodi Kaprodi
$mahasiswa_hadir_sebelumnya = []; // Mahasiswa yang sudah hadir di kegiatan ini
if (isset($_GET['action']) && $_GET['action'] == 'record_attendance' && isset($_GET['id'])) {
    $id_kegiatan_attendance = (int)$_GET['id'];

    // Cek kegiatan milik kaprodi ini
    $stmt_check_keg = $conn->prepare("SELECT id, nama_kegiatan, tanggal_pelaksanaan FROM kegiatan WHERE id = ? AND prodi_id = ?");
    $stmt_check_keg->bind_param("ii", $id_kegiatan_attendance, $kaprodi_prodi_id);
    $stmt_check_keg->execute();
    $result_check_keg = $stmt_check_keg->get_result();
    if ($result_check_keg->num_rows == 1) {
        $kegiatan_to_record_attendance = $result_check_keg->fetch_assoc();

        // Ambil semua mahasiswa dari prodi Kaprodi, diurutkan tahun masuk descending, nama ascending
        $stmt_mhs_prodi = $conn->prepare("SELECT id, nama_lengkap, nim, tahun_masuk FROM users WHERE role = 'mahasiswa' AND prodi_id = ? ORDER BY tahun_masuk DESC, nama_lengkap ASC");
        $stmt_mhs_prodi->bind_param("i", $kaprodi_prodi_id);
        $stmt_mhs_prodi->execute();
        $result_mhs_prodi = $stmt_mhs_prodi->get_result();
        while ($row = $result_mhs_prodi->fetch_assoc()) {
            $mahasiswa_prodi[] = $row;
        }
        $stmt_mhs_prodi->close();

        // Ambil mahasiswa yang sudah hadir pada kegiatan ini sebelumnya
        $stmt_hadir = $conn->prepare("SELECT mahasiswa_id FROM kehadiran_kegiatan WHERE kegiatan_id = ?");
        $stmt_hadir->bind_param("i", $id_kegiatan_attendance);
        $stmt_hadir->execute();
        $result_hadir = $stmt_hadir->get_result();
        while ($row = $result_hadir->fetch_assoc()) {
            $mahasiswa_hadir_sebelumnya[] = $row['mahasiswa_id'];
        }
        $stmt_hadir->close();

    } else {
        $error_message = "Kegiatan tidak ditemukan atau Anda tidak memiliki izin untuk mencatat kehadiran.";
        redirect('kegiatan.php'); // Redirect jika tidak valid
    }
    $stmt_check_keg->close();
}


$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Kegiatan - Kaprodi</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>Manajemen Kegiatan</h1>
        </header>
        <nav>
            <ul>
                <li><a href="dashboard_kaprodi.php">Dashboard</a></li>
                <li><a href="mahasiswa.php">Manajemen Mahasiswa</a></li>
                <li><a href="kegiatan.php">Manajemen Kegiatan</a></li>
                <li><a href="change_password.php">Ganti Password</a></li>
                <li><a href="logout.php">Logout</a></li>
            </ul>
        </nav>
        <main>
            <h2>Kelola Kegiatan Program Studi Anda</h2>
            <?php if (!empty($success_message)): ?>
                <div class="alert alert-success"><?php echo $success_message; ?></div>
            <?php endif; ?>
            <?php if (!empty($error_message)): ?>
                <div class="alert alert-danger"><?php echo $error_message; ?></div>
            <?php endif; ?>

            <?php if ($kegiatan_to_record_attendance): ?>
                <h3>Catat Kehadiran untuk Kegiatan: "<?php echo htmlspecialchars($kegiatan_to_record_attendance['nama_kegiatan']); ?>" (Tanggal: <?php echo date('d-m-Y', strtotime($kegiatan_to_record_attendance['tanggal_pelaksanaan'])); ?>)</h3>
                <form action="kegiatan.php" method="POST">
                    <input type="hidden" name="kegiatan_id" value="<?php echo htmlspecialchars($kegiatan_to_record_attendance['id']); ?>">
                    <div class="table-responsive">
                        <table>
                            <thead>
                                <tr>
                                    <th></th>
                                    <th>NIM</th>
                                    <th>Nama Lengkap</th>
                                    <th>Tahun Masuk</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($mahasiswa_prodi)): ?>
                                    <?php foreach ($mahasiswa_prodi as $mahasiswa): ?>
                                        <tr>
                                            <td>
                                                <input type="checkbox" name="mahasiswa_hadir[]" value="<?php echo $mahasiswa['id']; ?>"
                                                <?php echo in_array($mahasiswa['id'], $mahasiswa_hadir_sebelumnya) ? 'checked' : ''; ?>>
                                            </td>
                                            <td><?php echo htmlspecialchars($mahasiswa['nim']); ?></td>
                                            <td><?php echo htmlspecialchars($mahasiswa['nama_lengkap']); ?></td>
                                            <td><?php echo htmlspecialchars($mahasiswa['tahun_masuk']); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="4">Tidak ada mahasiswa di prodi Anda.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="form-group" style="margin-top: 20px;">
                        <button type="submit" name="record_kehadiran" class="btn">Simpan Kehadiran</button>
                        <a href="kegiatan.php" class="btn btn-warning">Batal</a>
                    </div>
                </form>
            <?php else: // Form Tambah/Edit Kegiatan ?>
                <h3><?php echo $kegiatan_to_edit ? 'Edit Kegiatan' : 'Tambah Kegiatan Baru'; ?></h3>
                <form action="kegiatan.php" method="POST">
                    <?php if ($kegiatan_to_edit): ?>
                        <input type="hidden" name="id_kegiatan" value="<?php echo htmlspecialchars($kegiatan_to_edit['id']); ?>">
                    <?php endif; ?>
                    <div class="form-group">
                        <label for="nama_kegiatan">Nama Kegiatan:</label>
                        <input type="text" id="nama_kegiatan" name="nama_kegiatan" value="<?php echo htmlspecialchars($kegiatan_to_edit['nama_kegiatan'] ?? ($_POST['nama_kegiatan'] ?? '')); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="kredit_poin">Kredit Poin:</label>
                        <input type="number" id="kredit_poin" name="kredit_poin" min="1" value="<?php echo htmlspecialchars($kegiatan_to_edit['kredit_poin'] ?? ($_POST['kredit_poin'] ?? '')); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="tanggal_pelaksanaan">Tanggal Pelaksanaan:</label>
                        <input type="date" id="tanggal_pelaksanaan" name="tanggal_pelaksanaan" value="<?php echo htmlspecialchars($kegiatan_to_edit['tanggal_pelaksanaan'] ?? ($_POST['tanggal_pelaksanaan'] ?? '')); ?>" required>
                    </div>
                    <div class="form-group">
                        <button type="submit" name="<?php echo $kegiatan_to_edit ? 'edit_kegiatan' : 'add_kegiatan'; ?>" class="btn"><?php echo $kegiatan_to_edit ? 'Update Kegiatan' : 'Tambah Kegiatan'; ?></button>
                        <?php if ($kegiatan_to_edit): ?>
                            <a href="kegiatan.php" class="btn btn-warning">Batal Edit</a>
                        <?php endif; ?>
                    </div>
                </form>

                <h3 style="margin-top: 40px;">Daftar Kegiatan Prodi Anda</h3>
                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Nama Kegiatan</th>
                                <th>Kredit Poin</th>
                                <th>Tanggal</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($kegiatan_list)): ?>
                                <?php $no = 1; foreach ($kegiatan_list as $kegiatan): ?>
                                    <tr>
                                        <td><?php echo $no++; ?></td>
                                        <td><?php echo htmlspecialchars($kegiatan['nama_kegiatan']); ?></td>
                                        <td><?php echo htmlspecialchars($kegiatan['kredit_poin']); ?></td>
                                        <td><?php echo date('d-m-Y', strtotime($kegiatan['tanggal_pelaksanaan'])); ?></td>
                                        <td>
                                            <a href="kegiatan.php?action=edit&id=<?php echo $kegiatan['id']; ?>" class="btn btn-warning btn-sm">Edit</a>
                                            <a href="kegiatan.php?action=delete&id=<?php echo $kegiatan['id']; ?>" class="btn btn-danger btn-sm confirm-delete">Hapus</a>
                                            <a href="kegiatan.php?action=record_attendance&id=<?php echo $kegiatan['id']; ?>" class="btn btn-primary btn-sm">Catat Kehadiran</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="5">Belum ada kegiatan yang ditambahkan.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; // End of if ($kegiatan_to_record_attendance) ?>
        </main>
    </div>
    <script src="assets/js/script.js"></script>
</body>
</html>