<?php
require_once 'config.php';
require_once 'functions.php';

if (isset($_SESSION['user_id'])) {
    // Jika sudah login, redirect ke dashboard yang sesuai
    if ($_SESSION['role'] == 'administrator') {
        redirect('dashboard_admin.php');
    } elseif ($_SESSION['role'] == 'kaprodi') {
        redirect('dashboard_kaprodi.php');
    } elseif ($_SESSION['role'] == 'mahasiswa') {
        redirect('dashboard_mahasiswa.php');
    }
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    if (empty($username) || empty($password)) {
        $error = "Username dan password harus diisi.";
    } else {
        $stmt = $conn->prepare("SELECT id, nama_lengkap, username, password, role, prodi_id FROM users WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows == 1) {
            $user = $result->fetch_assoc();
            if (password_verify($password, $user['password'])) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['nama_lengkap'] = $user['nama_lengkap'];
                $_SESSION['role'] = $user['role'];
                $_SESSION['prodi_id'] = $user['prodi_id'];

                if ($user['role'] == 'administrator') {
                    redirect('dashboard_admin.php');
                } elseif ($user['role'] == 'kaprodi') {
                    redirect('dashboard_kaprodi.php');
                } elseif ($user['role'] == 'mahasiswa') {
                    redirect('dashboard_mahasiswa.php');
                }
            } else {
                $error = "Password salah.";
            }
        } else {
            $error = "Username tidak ditemukan.";
        }
        $stmt->close();
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Sistem Kredit Poin</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>Login Sistem Kredit Poin</h1>
        </header>
        <main>
            <form action="login.php" method="post">
                <?php if (!empty($error)): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                <div class="form-group">
                    <label for="username">Username:</label>
                    <input type="text" id="username" name="username" required>
                </div>
                <div class="form-group">
                    <label for="password">Password:</label>
                    <input type="password" id="password" name="password" required>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn">Login</button>
                    <a href="register.php" class="btn">Register Mahasiswa</a>
                </div>
            </form>
        </main>
    </div>
    <script src="assets/js/script.js"></script>
</body>
</html>