<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate Password Hash</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .result-box {
            background-color: #e9ecef;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
            word-break: break-all;
        }
        .result-box h4 {
            margin-top: 0;
        }
        .result-box code {
            display: block;
            background-color: #f8f9fa;
            padding: 10px;
            border-radius: 3px;
            font-family: monospace;
            white-space: pre-wrap; /* Agar text wrapping */
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <h1>Generate Password Hash</h1>
        </header>
        <main>
            <p style="color: red; font-weight: bold;">PERINGATAN: File ini hanya untuk pengembangan dan testing. Hapus segera setelah selesai digunakan di lingkungan produksi!</p>

            <form action="pass.php" method="POST">
                <div class="form-group">
                    <label for="password_input">Masukkan Password:</label>
                    <input type="text" id="password_input" name="password_input" required>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn">Generate Hash</button>
                </div>
            </form>

            <?php
            if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['password_input'])) {
                $password_input = $_POST['password_input'];
                $hashed_password = password_hash($password_input, PASSWORD_DEFAULT);
            ?>
                <div class="result-box">
                    <h4>Password Asli:</h4>
                    <code><?php echo htmlspecialchars($password_input); ?></code>
                    <h4>Generated Hash:</h4>
                    <code><?php echo htmlspecialchars($hashed_password); ?></code>
                    <p style="margin-top: 15px;">Anda dapat menggunakan hash ini untuk mengupdate password di database.</p>
                </div>
            <?php
            }
            ?>
             <div style="margin-top: 20px;">
                <a href="login.php" class="btn btn-warning">Kembali ke Login</a>
            </div>
        </main>
    </div>
    <script src="assets/js/script.js"></script>
</body>
</html>