<?php
require_once 'config.php';
require_once 'functions.php';

$success = '';
$error = '';

// Ambil daftar prodi
$prodi_list = [];
$stmt = $conn->prepare("SELECT id, nama_prodi FROM prodi ORDER BY nama_prodi");
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $prodi_list[] = $row;
}
$stmt->close();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nama_lengkap = trim($_POST['nama_lengkap']);
    $nim = trim($_POST['nim']);
    $prodi_id = $_POST['prodi_id'];
    $no_wa = trim($_POST['no_wa']);
    $tahun_masuk = $_POST['tahun_masuk'];
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    $confirm_password = trim($_POST['confirm_password']);

    if (empty($nama_lengkap) || empty($nim) || empty($prodi_id) || empty($no_wa) || empty($tahun_masuk) || empty($username) || empty($password) || empty($confirm_password)) {
        $error = "Semua kolom harus diisi.";
    } elseif ($password !== $confirm_password) {
        $error = "Konfirmasi password tidak cocok.";
    } elseif (strlen($password) < 6) {
        $error = "Password minimal 6 karakter.";
    } else {
        // Cek NIM dan Username sudah ada atau belum
        $stmt_check = $conn->prepare("SELECT id FROM users WHERE nim = ? OR username = ?");
        $stmt_check->bind_param("ss", $nim, $username);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();
        if ($result_check->num_rows > 0) {
            $error = "NIM atau Username sudah terdaftar.";
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            $stmt = $conn->prepare("INSERT INTO users (nama_lengkap, nim, prodi_id, no_wa, tahun_masuk, username, password, role) VALUES (?, ?, ?, ?, ?, ?, ?, 'mahasiswa')");
            $stmt->bind_param("ssiisss", $nama_lengkap, $nim, $prodi_id, $no_wa, $tahun_masuk, $username, $hashed_password);

            if ($stmt->execute()) {
                $success = "Registrasi berhasil! Silakan login.";
                // Clear form fields
                $_POST = array();
            } else {
                $error = "Terjadi kesalahan saat registrasi: " . $stmt->error;
            }
            $stmt->close();
        }
        $stmt_check->close();
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrasi Kredit Poin  Mahasiswa</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>Registrasi Krodit Poin Mahasiswa</h1>
        </header><br>
<br>

        <main>
            <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <script>setTimeout(function(){ window.location.href='login.php'; }, 3000);</script>
            <?php endif; ?>
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            <form action="register.php" method="post">
                <div class="form-group">
                    <label for="nama_lengkap">Nama Lengkap:</label>
                    <input type="text" id="nama_lengkap" name="nama_lengkap" value="<?php echo $_POST['nama_lengkap'] ?? ''; ?>" required>
                </div>
                <div class="form-group">
                    <label for="nim">NIM:</label>
                    <input type="text" id="nim" name="nim" value="<?php echo $_POST['nim'] ?? ''; ?>" required>
                </div>
                <div class="form-group">
                    <label for="prodi_id">Program Studi:</label>
                    <select id="prodi_id" name="prodi_id" required>
                    
                        <?php foreach ($prodi_list as $prodi): ?>
                            <option value="<?php echo $prodi['id']; ?>" <?php echo (isset($_POST['prodi_id']) && $_POST['prodi_id'] == $prodi['id']) ? 'selected' : ''; ?>>
                                <?php echo $prodi['nama_prodi']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="no_wa">Nomor WhatsApp:</label>
                    <input type="text" id="no_wa" name="no_wa" value="<?php echo $_POST['no_wa'] ?? ''; ?>" required>
                </div>
                <div class="form-group">
                    <label for="tahun_masuk">Tahun Masuk:</label>
                    <input type="number" id="tahun_masuk" name="tahun_masuk" min="1900" max="<?php echo date('Y'); ?>" value="<?php echo $_POST['tahun_masuk'] ?? date('Y'); ?>" required>
                </div>
                <div class="form-group">
                    <label for="username">Username:</label>
                    <input type="text" id="username" name="username" value="<?php echo $_POST['username'] ?? ''; ?>" required>
                </div>
                <div class="form-group">
                    <label for="password">Password:</label>
                    <input type="password" id="password" name="password" required>
                </div>
                <div class="form-group">
                    <label for="confirm_password">Konfirmasi Password:</label>
                    <input type="password" id="confirm_password" name="confirm_password" required>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn">Register</button>
                    <a href="login.php" class="btn btn">Kembali ke Login</a>
                    <a href="index.php" class="btn btn">Kembali ke Beranda</a>
                </div>
            </form>
        </main>
    </div>
    <script src="assets/js/script.js"></script>
<br>
<br>
</body>
</html>